/* ...............................................................

	WindowColors
	Copyright 1997-8 Steve Klingsporn <moofie@pobox.com>
	Based on WindowShade by Marco Nelissen <marcone@xs4all.nl>
	
		File:	ColorLabel.h
	
	Contains:	Class definition and includes for ColorLabel
				BView subclass.
	
	   Notes:	None
	   
   ............................................................... */

#ifndef _COLOR_LABEL_H
#define _COLOR_LABEL_H

#ifndef _WINDOW_COLORS_PANEL_H
#include "WindowColorsPanel.h"
#endif

#ifndef _WINDOW_VIEW_H
#include "WindowView.h"
#endif

#ifndef _WINDOW_COLORS_H
#include "WindowColors.h"
#endif

#ifndef _VIEW_H
#include <View.h>
#endif

/* ...............................................................
	ColorLabel class	   
   ............................................................... */

class ColorLabel : public BView
{
	public:
							ColorLabel(BRect frame, 
											const char *name,
											window_color which);
			
			window_color	Which();
			rgb_color		Color();
			void			SetColor(rgb_color color,
									 bool quietly = false);
			
		WindowView			*ParentWindowView();
		
			void			Draw(BRect updateRect);
			void			MessageReceived(BMessage *message);
			void			MouseDown(BPoint where);
			void			MakeFocus(bool focused);
			void			WindowActivated(bool state);
			void			KeyDown(const char *bytes, int32 numBytes);

	private:
	
			BRect			LabelBounds();
			BRect			DivotBounds();
			
			float			_labelStringWidth;
			window_color	_which;
};

#endif